/*
 * Decompiled with CFR 0.152.
 */
package jade.tools.logging;

import jade.content.lang.sl.SLCodec;
import jade.core.Agent;
import jade.core.ContainerID;
import jade.domain.FIPAAgentManagement.APDescription;
import jade.domain.JADEAgentManagement.JADEManagementOntology;
import jade.domain.introspection.AMSSubscriber;
import jade.domain.introspection.AddedContainer;
import jade.domain.introspection.Event;
import jade.domain.introspection.PlatformDescription;
import jade.domain.introspection.RemovedContainer;
import jade.tools.logging.gui.LogManagerGUI;
import jade.tools.logging.ontology.LogManagementOntology;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;

public class LogManagerAgent
extends Agent {
    private LogManagerGUI myGui;
    private APDescription myPlatformProfile;
    private AMSSubscriber myAMSSubscriber;

    protected void setup() {
        this.getContentManager().registerLanguage(new SLCodec());
        this.getContentManager().registerOntology(JADEManagementOntology.getInstance());
        this.getContentManager().registerOntology(LogManagementOntology.getInstance());
        this.myAMSSubscriber = new AMSSubscriber(){

            protected void installHandlers(Map handlersTable) {
                handlersTable.put("meta_reset-events", new AMSSubscriber.EventHandler(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void handle(Event ev) {
                        LogManagerAgent.access$100(1.access$000(this.this$1)).resetTree();
                    }
                });
                handlersTable.put("added-container", new AMSSubscriber.EventHandler(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void handle(Event ev) {
                        AddedContainer ac = (AddedContainer)ev;
                        ContainerID cid = ac.getContainer();
                        String name = cid.getName();
                        String address = cid.getAddress();
                        try {
                            InetAddress addr = InetAddress.getByName(address);
                            LogManagerAgent.access$100(1.access$000(this.this$1)).addContainer(name, addr);
                        }
                        catch (UnknownHostException uhe) {
                            LogManagerAgent.access$100(1.access$000(this.this$1)).addContainer(name, null);
                        }
                    }
                });
                handlersTable.put("removed-container", new AMSSubscriber.EventHandler(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void handle(Event ev) {
                        RemovedContainer rc = (RemovedContainer)ev;
                        ContainerID cid = rc.getContainer();
                        String name = cid.getName();
                        LogManagerAgent.access$100(1.access$000(this.this$1)).removeContainer(name);
                    }
                });
                handlersTable.put("platform-description", new AMSSubscriber.EventHandler(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void handle(Event ev) {
                        PlatformDescription pd = (PlatformDescription)ev;
                        APDescription APdesc = pd.getPlatform();
                        LogManagerAgent.access$202(1.access$000(this.this$1), APdesc);
                        LogManagerAgent.access$100(1.access$000(this.this$1)).refreshLocalPlatformName(LogManagerAgent.access$200(1.access$000(this.this$1)).getName());
                    }
                });
            }

            static /* synthetic */ LogManagerAgent access$000(1 x0) {
                return x0.LogManagerAgent.this;
            }
        };
        this.addBehaviour(this.myAMSSubscriber);
        this.myGui = new LogManagerGUI(this);
        this.myGui.showCorrect();
    }

    protected void takeDown() {
        this.myGui.dispose();
        this.send(this.myAMSSubscriber.getCancel());
    }

    static /* synthetic */ LogManagerGUI access$100(LogManagerAgent x0) {
        return x0.myGui;
    }

    static /* synthetic */ APDescription access$202(LogManagerAgent x0, APDescription x1) {
        x0.myPlatformProfile = x1;
        return x0.myPlatformProfile;
    }

    static /* synthetic */ APDescription access$200(LogManagerAgent x0) {
        return x0.myPlatformProfile;
    }
}

